# 🔥 دليل تنصيب مشروع أون فاير على cPanel - Laravel Version

## 📋 المتطلبات الأساسية

### ✅ **متطلبات الاستضافة:**
- **PHP 8.1** أو أحدث
- **MySQL 5.7** أو أحدث (أو MariaDB 10.3+)
- **مساحة تخزين:** 500MB على الأقل
- **Composer** (إذا كان متاحاً)
- **SSH Access** (مستحسن)

### ✅ **Extensions مطلوبة:**
- BCMath PHP Extension
- Ctype PHP Extension  
- Fileinfo PHP Extension
- JSON PHP Extension
- Mbstring PHP Extension
- OpenSSL PHP Extension
- PDO PHP Extension
- Tokenizer PHP Extension
- XML PHP Extension
- cURL PHP Extension
- GD Library (للصور)

---

## 🚀 خطوات التنصيب التفصيلية

### **الخطوة 1: تحضير الملفات**

#### **أ. رفع الملفات:**

1. **ضغط المشروع:**
   ```bash
   # على جهازك المحلي
   zip -r burger-on-fire-laravel.zip burger-on-fire-laravel/
   ```

2. **رفع الملفات عبر File Manager:**
   - سجل دخول إلى cPanel
   - افتح "File Manager"
   - اذهب إلى المجلد الرئيسي (عادة `/home/username/`)
   - ارفع ملف ZIP
   - استخرج الملفات

#### **ب. ترتيب الملفات:**

```
public_html/          <- محتويات مجلد public
├── index.php
├── .htaccess
├── manifest.json
├── sw.js
└── images/
    ├── icons/
    └── ...

burger-on-fire/       <- باقي ملفات المشروع (خارج public_html)
├── app/
├── bootstrap/
├── config/
├── database/
├── resources/
├── routes/
├── storage/
├── vendor/
├── .env
├── artisan
├── composer.json
└── ...
```

### **الخطوة 2: إعداد قاعدة البيانات**

#### **أ. إنشاء قاعدة البيانات:**

1. **في cPanel:**
   - اذهب إلى "MySQL Databases"
   - أنشئ قاعدة بيانات جديدة: `burger_on_fire`
   - أنشئ مستخدم جديد: `burger_user`
   - أعطي المستخدم جميع الصلاحيات على قاعدة البيانات

#### **ب. تشغيل Migration:**

```bash
# عبر SSH (إذا كان متاحاً)
cd /path/to/burger-on-fire
php artisan migrate --seed

# أو عبر cPanel Terminal أو File Manager
```

### **الخطوة 3: تكوين ملف .env**

انسخ `.env.example` إلى `.env` وعدّل الإعدادات:

```env
# إعدادات التطبيق
APP_NAME="أون فاير - Burger On Fire"
APP_ENV=production
APP_KEY=base64:YOUR_APP_KEY_HERE
APP_DEBUG=false
APP_URL=https://yourdomain.com

# قاعدة البيانات
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=burger_on_fire
DB_USERNAME=burger_user
DB_PASSWORD=your_database_password

# البريد الإلكتروني
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=info@yourdomain.com
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=info@yourdomain.com
MAIL_FROM_NAME="${APP_NAME}"

# إعدادات المطعم
RESTAURANT_NAME="أون فاير"
RESTAURANT_PHONE="01234567890"
RESTAURANT_EMAIL="info@yourdomain.com"
RESTAURANT_ADDRESS="دمنهور، البحيرة، مصر"

# إعدادات التوصيل
DELIVERY_FEE=20
FREE_DELIVERY_THRESHOLD=150
DELIVERY_TIME_MIN=25
DELIVERY_TIME_MAX=45

# وسائل التواصل الاجتماعي
FACEBOOK_URL=https://facebook.com/burgeronfire
INSTAGRAM_URL=https://instagram.com/burgeronfire
TWITTER_URL=https://twitter.com/burgeronfire
```

### **الخطوة 4: إعداد الأذونات**

```bash
# أذونات المجلدات (777 للتطوير، 755 للإنتاج)
chmod -R 755 /path/to/burger-on-fire
chmod -R 755 public_html/

# أذونات خاصة
chmod -R 777 burger-on-fire/storage/
chmod -R 777 burger-on-fire/bootstrap/cache/
chmod 644 burger-on-fire/.env
```

### **الخطوة 5: تثبيت Dependencies (إذا كان Composer متاحاً)**

```bash
# عبر SSH
cd /path/to/burger-on-fire
composer install --no-dev --optimize-autoloader

# توليد مفتاح التطبيق
php artisan key:generate

# تحسين للإنتاج
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### **الخطوة 6: إعداد SSL Certificate**

1. **في cPanel:**
   - اذهب إلى "SSL/TLS"
   - فعّل "Let's Encrypt SSL" (مجاني)
   - أو ارفع شهادة SSL مدفوعة

2. **إعادة توجيه HTTPS:**
   - فعّل "Force HTTPS Redirect"

---

## ⚙️ الإعدادات المتقدمة

### **إعداد Cron Jobs للمهام المجدولة:**

```bash
# في cPanel → Cron Jobs
# أضف هذه المهمة لتشغيل كل دقيقة:
* * * * * cd /path/to/burger-on-fire && php artisan schedule:run >> /dev/null 2>&1
```

### **إعداد Queue Workers (اختياري):**

```bash
# لمعالجة المهام في الخلفية
php artisan queue:work --daemon
```

### **تحسين الأداء:**

```bash
# تحسين Composer
composer dump-autoload --optimize --no-dev

# تحسين Laravel
php artisan optimize
```

---

## 📁 هيكل الملفات النهائي

```
yourdomain.com/
├── public_html/                    <- الملفات العامة
│   ├── index.php                  <- نقطة الدخول
│   ├── .htaccess                  <- إعادة توجيه
│   ├── manifest.json              <- PWA manifest  
│   ├── sw.js                      <- Service Worker
│   ├── images/                    <- الصور
│   │   ├── icons/                 <- أيقونات PWA
│   │   ├── products/              <- صور المنتجات
│   │   └── categories/            <- صور الفئات
│   └── css/                       <- ملفات CSS (إذا كانت موجودة)
│
├── burger-on-fire/                <- تطبيق Laravel (خارج public_html)
│   ├── app/                       <- منطق التطبيق
│   │   ├── Http/Controllers/      <- Controllers
│   │   ├── Models/               <- Models  
│   │   └── ...
│   ├── config/                    <- ملفات التكوين
│   ├── database/                  <- Migrations & Seeders
│   │   ├── migrations/
│   │   └── seeders/
│   ├── resources/                 <- Views & Assets
│   │   └── views/
│   ├── routes/                    <- ملفات التوجيه
│   ├── storage/                   <- ملفات مؤقتة (777)
│   │   ├── app/
│   │   ├── framework/
│   │   └── logs/
│   ├── vendor/                    <- مكتبات Composer
│   ├── .env                       <- متغيرات البيئة (644)
│   ├── artisan                    <- CLI tool
│   └── composer.json
│
├── logs/                          <- سجلات الخادم (اختياري)
└── backups/                       <- نسخ احتياطية (اختياري)
```

---

## 🔧 استكشاف الأخطاء وإصلاحها

### **مشكلة: "500 Internal Server Error"**

```bash
# 1. تحقق من سجل الأخطاء
tail -f /path/to/error.log

# 2. تحقق من أذونات الملفات
chmod -R 755 burger-on-fire/
chmod -R 777 burger-on-fire/storage/

# 3. تحقق من .env
php artisan config:clear
```

### **مشكلة: "Class not found"**

```bash
# إعادة توليد autoload
composer dump-autoload

# مسح cache
php artisan cache:clear
php artisan config:clear
```

### **مشكلة: "Database connection failed"**

```bash
# تحقق من إعدادات قاعدة البيانات في .env
# تأكد من أن المستخدم له صلاحيات على قاعدة البيانات
```

### **مشكلة: "Route not found"**

```bash
# مسح route cache
php artisan route:clear

# إعادة تحميل routes
php artisan route:cache
```

---

## 🚀 بدء التشغيل

### **اختبار الموقع:**

1. **زيارة الموقع:**
   ```
   https://yourdomain.com
   ```

2. **اختبار المميزات الأساسية:**
   - ✅ الصفحة الرئيسية تظهر بشكل صحيح
   - ✅ قائمة المنتجات تعمل
   - ✅ سلة التسوق تعمل
   - ✅ نموذج التواصل يرسل بنجاح
   - ✅ PWA يمكن تثبيته

3. **اختبار الأداء:**
   ```
   # استخدم أدوات مثل:
   - Google PageSpeed Insights
   - GTmetrix
   - Pingdom
   ```

### **إضافة بيانات تجريبية:**

```bash
# تشغيل Seeders لإضافة منتجات ووهمية
php artisan db:seed
```

---

## 📊 المراقبة والصيانة

### **نسخ احتياطية يومية:**

```bash
#!/bin/bash
# إنشاء نسخة احتياطية لقاعدة البيانات
mysqldump -u burger_user -p burger_on_fire > backup_$(date +%Y%m%d).sql

# ضغط الملفات
tar -czf website_backup_$(date +%Y%m%d).tar.gz burger-on-fire/
```

### **تحديث التطبيق:**

```bash
# تحديث المكتبات
composer update --no-dev

# تشغيل migrations جديدة
php artisan migrate

# مسح cache
php artisan optimize:clear
php artisan optimize
```

### **مراقبة الأداء:**

- **مساحة القرص:** تحقق دورياً من مساحة التخزين
- **قاعدة البيانات:** راقب حجم قاعدة البيانات
- **الذاكرة:** تأكد من كفاية الذاكرة المتاحة
- **سجلات الأخطاء:** راجع السجلات يومياً

---

## 🛡️ الأمان والحماية

### **إعدادات الأمان الموصى بها:**

```apache
# في .htaccess الرئيسي
<Files ".env">
    Order Allow,Deny
    Deny from all
</Files>

<Files "*.log">
    Order Allow,Deny 
    Deny from all
</Files>

# منع الوصول للمجلدات الحساسة
RedirectMatch 403 ^/storage/.*$
RedirectMatch 403 ^/vendor/.*$
```

### **تحديثات الأمان:**

- ✅ حدّث PHP دورياً
- ✅ حدّث Laravel للإصدارات الأمنية
- ✅ استخدم كلمات مرور قوية
- ✅ فعّل توثيق العاملين (2FA) لـ cPanel
- ✅ راجع سجلات الوصول دورياً

---

## 📞 الدعم والمساعدة

### **في حالة وجود مشاكل:**

1. **راجع سجل الأخطاء:**
   ```bash
   tail -50 /path/to/storage/logs/laravel.log
   ```

2. **تحقق من إعدادات PHP:**
   ```php
   <?php phpinfo(); ?>
   ```

3. **اختبار الاتصال بقاعدة البيانات:**
   ```bash
   php artisan tinker
   >>> DB::connection()->getPdo();
   ```

### **موارد مفيدة:**

- **وثائق Laravel:** https://laravel.com/docs
- **مجتمع Laravel:** https://laracasts.com
- **Stack Overflow:** البحث عن حلول محددة
- **GitHub Issues:** للمشاكل المتعلقة بالمكتبات

---

## ✅ قائمة التحقق النهائية

### **قبل الإطلاق:**

- [ ] تم تثبيت جميع المكتبات المطلوبة
- [ ] تم إعداد قاعدة البيانات بشكل صحيح
- [ ] تم تكوين ملف .env
- [ ] تم إعداد SSL Certificate
- [ ] تم اختبار جميع المميزات الأساسية
- [ ] تم تحسين الأداء
- [ ] تم إعداد النسخ الاحتياطية
- [ ] تم اختبار سرعة التحميل
- [ ] تم اختبار المتجاوبية على الأجهزة المختلفة
- [ ] تم اختبار PWA وإمكانية التثبيت

### **بعد الإطلاق:**

- [ ] مراقبة سجلات الأخطاء
- [ ] تتبع حركة المرور
- [ ] اختبار النسخ الاحتياطية
- [ ] تحديث المحتوى دورياً
- [ ] مراجعة الأداء أسبوعياً

---

**🎉 تهانينا! موقع أون فاير Laravel أصبح جاهزاً للعمل! 🔥**

**الموقع متاح الآن على:** `https://yourdomain.com`

---

**ملاحظات مهمة:**
1. **استبدل** `yourdomain.com` بالنطاق الفعلي
2. **استبدل** جميع كلمات المرور بكلمات قوية
3. **احتفظ** بنسخة احتياطية من ملف `.env`
4. **راجع** سجلات الأخطاء دورياً

**للدعم التقني:** تواصل مع مزود الاستضافة أو مطور Laravel مختص.
