# 🔥 أون فاير - Burger On Fire (Laravel Version)

<div align="center">

![Burger On Fire Logo](public/images/logo.png)

**أشهى برجر في دمنهور | توصيل سريع خلال 30 دقيقة**

[![Laravel](https://img.shields.io/badge/Laravel-10.x-red.svg)](https://laravel.com)
[![PHP](https://img.shields.io/badge/PHP-8.1+-blue.svg)](https://php.net)
[![PWA](https://img.shields.io/badge/PWA-Ready-green.svg)](https://web.dev/progressive-web-apps/)
[![License](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)

</div>

---

## 📋 نظرة عامة

**أون فاير** هو موقع إلكتروني متطور لمطعم البرجر في دمنهور، مبني بتقنية **Laravel** و **TailwindCSS**. يوفر تجربة طلب طعام سلسة ومتطورة مع دعم كامل للغة العربية ومميزات **PWA**.

### ✨ **المميزات الرئيسية:**

- 🍔 **قائمة طعام تفاعلية** مع فئات وصور عالية الجودة
- 🛒 **سلة تسوق ذكية** مع حفظ العناصر والكوبونات
- 👤 **نظام عضوية متطور** مع 4 مستويات (برونزي، فضي، ذهبي، بلاتيني)
- ⭐ **نظام نقاط الولاء** مع مكافآت ومزايا
- 💳 **نظام كوبونات الخصم** المتقدم
- 📱 **PWA متكامل** يعمل كتطبيق هاتف
- 🌍 **دعم كامل للغة العربية** (RTL)
- 📊 **تتبع الطلبات المباشر**
- 🔐 **نظام أمان متقدم**

---

## 🚀 التثبيت والتشغيل

### **المتطلبات الأساسية:**

- **PHP 8.1+** مع Extensions اللازمة
- **MySQL 5.7+** أو MariaDB 10.3+
- **Composer** لإدارة المكتبات
- **Node.js** (اختياري للتطوير)

### **خطوات التثبيت:**

#### **1. استنساخ المشروع:**
```bash
git clone https://github.com/your-username/burger-on-fire-laravel.git
cd burger-on-fire-laravel
```

#### **2. تثبيت المكتبات:**
```bash
composer install --no-dev --optimize-autoloader
```

#### **3. إعداد البيئة:**
```bash
cp .env.example .env
php artisan key:generate
```

#### **4. إعداد قاعدة البيانات:**
```bash
# تحديث .env بمعلومات قاعدة البيانات
php artisan migrate --seed
```

#### **5. إعداد الأذونات:**
```bash
chmod -R 755 storage bootstrap/cache
```

#### **6. تشغيل الخادم:**
```bash
php artisan serve
```

🎉 **الموقع متاح الآن على:** `http://localhost:8000`

---

## 🏗️ هيكل المشروع

```
burger-on-fire-laravel/
│
├── 📁 app/                          # منطق التطبيق
│   ├── Http/Controllers/            # Controllers
│   │   ├── AuthController.php       # مصادقة المستخدمين
│   │   ├── CartController.php       # سلة التسوق
│   │   ├── HomeController.php       # الصفحة الرئيسية
│   │   └── ProductController.php    # إدارة المنتجات
│   └── Models/                      # نماذج البيانات
│       ├── User.php                 # نموذج المستخدم
│       ├── Product.php              # نموذج المنتج
│       ├── Order.php                # نموذج الطلب
│       ├── Category.php             # نموذج الفئة
│       ├── CartItem.php             # عنصر السلة
│       └── Coupon.php               # كوبون الخصم
│
├── 📁 database/                     # قاعدة البيانات
│   ├── migrations/                  # جداول قاعدة البيانات
│   └── seeders/                     # بيانات تجريبية
│       └── DatabaseSeeder.php       # منتجات وفئات نموذجية
│
├── 📁 resources/                    # الموارد والعرض
│   └── views/                       # صفحات Blade
│       ├── layouts/app.blade.php    # التخطيط الأساسي
│       ├── partials/               # المكونات المشتركة
│       │   ├── navbar.blade.php     # شريط التنقل
│       │   └── footer.blade.php     # تذييل الموقع
│       ├── auth/                   # صفحات المصادقة
│       │   ├── login.blade.php      # تسجيل دخول
│       │   └── register.blade.php   # إنشاء حساب
│       ├── cart/                   # سلة التسوق
│       │   └── index.blade.php      # عرض السلة
│       └── home.blade.php          # الصفحة الرئيسية
│
├── 📁 routes/                      # توجيه الصفحات
│   └── web.php                     # جميع المسارات
│
├── 📁 public/                      # الملفات العامة
│   ├── index.php                   # نقطة الدخول
│   ├── .htaccess                   # إعدادات Apache
│   ├── manifest.json               # PWA Manifest
│   ├── sw.js                       # Service Worker
│   └── images/                     # الصور والأيقونات
│
├── 📁 config/                      # ملفات التكوين
├── 📁 bootstrap/                   # ملفات الإقلاع
├── 📄 composer.json                # مكتبات PHP
├── 📄 .env.example                 # نموذج متغيرات البيئة
├── 📄 artisan                      # أوامر Laravel CLI
└── 📄 README.md                    # هذا الملف
```

---

## 🔧 إعدادات متقدمة

### **متغيرات البيئة (.env):**

```env
# إعدادات التطبيق
APP_NAME="أون فاير - Burger On Fire"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

# قاعدة البيانات
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_DATABASE=burger_on_fire
DB_USERNAME=your_username
DB_PASSWORD=your_password

# إعدادات المطعم
RESTAURANT_NAME="أون فاير"
RESTAURANT_PHONE="01234567890"
RESTAURANT_EMAIL="info@burgeronfire.com"
RESTAURANT_ADDRESS="دمنهور، البحيرة، مصر"

# إعدادات التوصيل
DELIVERY_FEE=20
FREE_DELIVERY_THRESHOLD=150
DELIVERY_TIME_MIN=25
DELIVERY_TIME_MAX=45

# وسائل التواصل الاجتماعي
FACEBOOK_URL=https://facebook.com/burgeronfire
INSTAGRAM_URL=https://instagram.com/burgeronfire
TWITTER_URL=https://twitter.com/burgeronfire
```

---

## 📦 المكونات والمميزات

### **🛒 نظام سلة التسوق:**
- إضافة وحذف المنتجات
- تحديث الكميات تلقائياً
- حفظ السلة للمستخدمين المسجلين
- حساب التكلفة الإجمالية والضرائب
- تطبيق كوبونات الخصم

### **👤 نظام العضوية:**
- **برونزي:** العضوية الأساسية
- **فضي:** خصم 5% + نقاط إضافية
- **ذهبي:** خصم 10% + توصيل مجاني + دعم أولوية
- **بلاتيني:** خصم 15% + جميع المميزات السابقة

### **⭐ نظام نقاط الولاء:**
- نقاط لكل طلب (1 نقطة لكل 10 جنيه)
- مضاعف النقاط حسب مستوى العضوية
- استبدال النقاط بخصومات
- نقاط إضافية للأنشطة (تسجيل الدخول، المراجعات)

### **💳 نظام الكوبونات:**
- خصومات نسبية وثابتة
- حد أدنى للطلب
- حد أقصى للخصم
- فترات صلاحية محددة
- حد لعدد الاستخدامات

---

## 📱 مميزات PWA

الموقع يدعم **Progressive Web App** بالكامل:

### **التثبيت:**
1. زيارة الموقع على الهاتف
2. النقر على "إضافة إلى الشاشة الرئيسية"
3. استخدام الموقع كتطبيق مستقل

### **المميزات:**
- ✅ **العمل بدون إنترنت** للصفحات المُحمّلة
- ✅ **إشعارات الدفع** للطلبات الجديدة
- ✅ **تحديثات تلقائية** للمحتوى
- ✅ **أيقونة على الشاشة الرئيسية**
- ✅ **شاشة بداية مخصصة**

---

## 🔒 الأمان والحماية

### **مميزات الأمان المطبقة:**
- ✅ **حماية CSRF** لجميع النماذج
- ✅ **تشفير كلمات المرور** باستخدام Bcrypt
- ✅ **تنظيف المدخلات** ضد XSS
- ✅ **Headers أمان** (CSP, HSTS, X-Frame-Options)
- ✅ **حماية ملفات البيئة** من الوصول المباشر
- ✅ **Rate Limiting** لمنع الـ Spam
- ✅ **إجراءات قاعدة البيانات الآمنة** (Prepared Statements)

### **نصائح الأمان:**
```bash
# تحديث دوري للمكتبات
composer audit
php artisan security:check

# نسخ احتياطية منتظمة
php artisan backup:run

# تفعيل HTTPS في الإنتاج
# استخدام كلمات مرور قوية
# مراقبة سجلات الأخطاء
```

---

## 🌐 النشر على cPanel

### **دليل مفصل:**
راجع ملف [`CPANEL_INSTALLATION_GUIDE.md`](CPANEL_INSTALLATION_GUIDE.md) للحصول على دليل شامل لنشر الموقع على cPanel.

### **خطوات سريعة:**
1. **رفع الملفات:** محتويات `public/` إلى `public_html/`
2. **إعداد قاعدة البيانات:** إنشاء قاعدة البيانات والمستخدم
3. **تكوين .env:** تحديث إعدادات قاعدة البيانات
4. **تشغيل Migration:** `php artisan migrate --seed`
5. **إعداد SSL:** تفعيل شهادة SSL
6. **اختبار الموقع:** التأكد من عمل جميع المميزات

---

## 🛠️ التطوير والتخصيص

### **إضافة منتجات جديدة:**
```php
// في database/seeders/DatabaseSeeder.php
Product::create([
    'category_id' => 1,
    'name' => 'منتج جديد',
    'description' => 'وصف المنتج',
    'price' => 100.00,
    'image' => 'product-image.jpg',
    'is_active' => true
]);
```

### **إضافة كوبونات خصم:**
```php
// في database/seeders/DatabaseSeeder.php
Coupon::create([
    'code' => 'NEWCODE',
    'type' => 'percentage', // أو 'fixed'
    'value' => 20.00,
    'minimum_amount' => 100.00,
    'starts_at' => now(),
    'expires_at' => now()->addDays(30)
]);
```

### **تخصيص الألوان:**
```javascript
// في resources/views/layouts/app.blade.php
tailwind.config = {
    theme: {
        extend: {
            colors: {
                'fire': {
                    500: '#f97316', // اللون الأساسي
                    600: '#ea580c'  // اللون الداكن
                }
            }
        }
    }
}
```

---

## 📊 الإحصائيات والتحليلات

### **المقاييس المتاحة:**
- إجمالي عدد العملاء
- متوسط قيمة الطلب
- أكثر المنتجات مبيعاً
- معدل استخدام الكوبونات
- توزيع مستويات العضوية

### **تتبع التحويلات:**
```javascript
// في layouts/app.blade.php
// Google Analytics
gtag('event', 'purchase', {
    transaction_id: 'ORDER_ID',
    value: 150.00,
    currency: 'EGP'
});
```

---

## 🤝 المساهمة والتطوير

### **كيفية المساهمة:**
1. **Fork** المشروع
2. إنشاء branch جديد (`git checkout -b feature/amazing-feature`)
3. Commit التغييرات (`git commit -m 'Add amazing feature'`)
4. Push إلى البranch (`git push origin feature/amazing-feature`)
5. إنشاء **Pull Request**

### **معايير المساهمة:**
- ✅ كتابة كود نظيف ومُعلّق
- ✅ اتباع PSR-12 coding standards
- ✅ إضافة tests للمميزات الجديدة
- ✅ توثيق التغييرات في README

---

## 📞 الدعم والمساعدة

### **الحصول على المساعدة:**
- 📧 **البريد الإلكتروني:** info@burgeronfire.com
- 💬 **مجتمع Laravel:** [Laracasts](https://laracasts.com)
- 📖 **وثائق Laravel:** [Laravel Docs](https://laravel.com/docs)
- 🐛 **البلاغات:** [GitHub Issues](https://github.com/your-username/burger-on-fire-laravel/issues)

### **موارد مفيدة:**
- [دليل Laravel بالعربية](https://laravel-ar.com/)
- [مجتمع المطورين العرب](https://arab-programmers.com/)
- [TailwindCSS Documentation](https://tailwindcss.com/docs)

---

## 🏆 الاعتمادات

### **التقنيات المستخدمة:**
- [Laravel](https://laravel.com) - إطار عمل PHP
- [TailwindCSS](https://tailwindcss.com) - إطار عمل CSS
- [Alpine.js](https://alpinejs.dev) - JavaScript framework
- [Heroicons](https://heroicons.com) - الأيقونات

### **الخطوط المستخدمة:**
- [Cairo Font](https://fonts.google.com/specimen/Cairo) - خط عربي
- [Tajawal Font](https://fonts.google.com/specimen/Tajawal) - خط عربي احتياطي

---

## 📄 الرخصة

هذا المشروع مرخص تحت رخصة **MIT**. راجع ملف [`LICENSE`](LICENSE) للتفاصيل.

---

## 🎯 خارطة طريق التطوير

### **الإصدار الحالي (v1.0):**
- ✅ الموقع الأساسي مع جميع المميزات
- ✅ نظام العضوية ونقاط الولاء
- ✅ PWA متكامل
- ✅ دعم cPanel

### **الإصدار التالي (v1.1):**
- 🔜 لوحة تحكم للإدارة
- 🔜 تطبيق جوال أصلي (React Native)
- 🔜 نظام دفع إلكتروني متكامل
- 🔜 API للتطبيقات الخارجية

### **المستقبل (v2.0):**
- 🔜 نظام متعدد المطاعم
- 🔜 ذكاء اصطناعي لاقتراح المنتجات
- 🔜 نظام توصيل متقدم مع GPS
- 🔜 تحليلات متقدمة ومخططات بيانية

---

<div align="center">

**🔥 صُنع بحب في مصر 🇪🇬**

**أون فاير - أشهى برجر في دمنهور**

[![Website](https://img.shields.io/badge/Website-burgeronfire.com-orange.svg)](https://burgeronfire.com)
[![Facebook](https://img.shields.io/badge/Facebook-BurgerOnFire-blue.svg)](https://facebook.com/burgeronfire)
[![Instagram](https://img.shields.io/badge/Instagram-@burgeronfire-purple.svg)](https://instagram.com/burgeronfire)

---

**إذا أعجبك هذا المشروع، لا تنس إعطاءه ⭐ على GitHub!**

</div>
