<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'product_id',
        'quantity',
        'price',
        'customizations',
        'special_instructions'
    ];

    protected $casts = [
        'customizations' => 'array',
        'price' => 'decimal:2'
    ];

    // العلاقات
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Helper methods
    public function getTotalPriceAttribute()
    {
        return $this->price * $this->quantity;
    }

    public function getFormattedTotalPriceAttribute()
    {
        return number_format($this->total_price, 0) . ' جنيه';
    }

    public function hasCustomizations()
    {
        return !empty($this->customizations) && is_array($this->customizations);
    }

    public function getCustomizationText()
    {
        if (!$this->hasCustomizations()) {
            return '';
        }

        $text = [];
        foreach ($this->customizations as $type => $options) {
            if (!empty($options)) {
                $text[] = $type . ': ' . implode(', ', $options);
            }
        }

        return implode(' | ', $text);
    }
}
