<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Product;
use App\Models\Coupon;
use Carbon\Carbon;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            CategoriesTableSeeder::class,
            ProductsTableSeeder::class,
            CouponsTableSeeder::class,
        ]);
    }
}

class CategoriesTableSeeder extends Seeder
{
    public function run()
    {
        $categories = [
            [
                'name' => 'البرجر الكلاسيك',
                'name_en' => 'Classic Burgers',
                'description' => 'أشهى أنواع البرجر التقليدي بالنكهات الأصلية',
                'icon' => 'burger-classic.svg',
                'image' => 'category-classic-burgers.jpg',
                'sort_order' => 1
            ],
            [
                'name' => 'البرجر المميز',
                'name_en' => 'Premium Burgers',
                'description' => 'برجر بمكونات مميزة وطعم استثنائي',
                'icon' => 'burger-premium.svg',
                'image' => 'category-premium-burgers.jpg',
                'sort_order' => 2
            ],
            [
                'name' => 'برجر الدجاج',
                'name_en' => 'Chicken Burgers',
                'description' => 'برجر الدجاج المقرمش بأشهى الطعمات',
                'icon' => 'chicken-burger.svg',
                'image' => 'category-chicken-burgers.jpg',
                'sort_order' => 3
            ],
            [
                'name' => 'الوجبات العائلية',
                'name_en' => 'Family Meals',
                'description' => 'وجبات مميزة للعائلة والأصدقاء',
                'icon' => 'family-meals.svg',
                'image' => 'category-family-meals.jpg',
                'sort_order' => 4
            ],
            [
                'name' => 'المشروبات',
                'name_en' => 'Beverages',
                'description' => 'مشروبات طازجة ومنعشة',
                'icon' => 'beverages.svg',
                'image' => 'category-beverages.jpg',
                'sort_order' => 5
            ],
            [
                'name' => 'الحلويات',
                'name_en' => 'Desserts',
                'description' => 'حلويات لذيذة لإنهاء وجبتك بأحلى طعم',
                'icon' => 'desserts.svg',
                'image' => 'category-desserts.jpg',
                'sort_order' => 6
            ]
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}

class ProductsTableSeeder extends Seeder
{
    public function run()
    {
        $products = [
            // البرجر الكلاسيك
            [
                'category_id' => 1,
                'name' => 'كلاسيك برجر',
                'name_en' => 'Classic Burger',
                'description' => 'قطعة من البرجر المشوي، خس، صوص أون فاير، صوص تكساس، شرائح خيار مخلل، طماطم',
                'price' => 95.00,
                'original_price' => 120.00,
                'image' => 'classic-burger.jpg',
                'is_featured' => true,
                'is_popular' => true,
                'preparation_time' => '15-20 دقيقة',
                'calories' => 650,
                'ingredients' => ['لحم بقري', 'خس', 'طماطم', 'خيار مخلل', 'صوص خاص'],
                'allergens' => ['جلوتين', 'ألبان'],
                'customizations' => [
                    'الإضافات' => ['جبن شيدر +10 جنيه', 'بيكون +15 جنيه', 'فطر مشوي +8 جنيه'],
                    'درجة الطبخ' => ['مطبوخ جيداً', 'متوسط', 'نصف مطبوخ'],
                    'نوع الخبز' => ['خبز سمسم', 'خبز بذور', 'خبز عادي']
                ],
                'sort_order' => 1
            ],
            [
                'category_id' => 1,
                'name' => 'تشيز برجر',
                'name_en' => 'Cheese Burger',
                'description' => 'برجر كلاسيك مع جبن شيدر ذائب وصوص الجبن الخاص',
                'price' => 110.00,
                'original_price' => null,
                'image' => 'cheese-burger.jpg',
                'is_featured' => false,
                'is_popular' => true,
                'preparation_time' => '15-20 دقيقة',
                'calories' => 720,
                'ingredients' => ['لحم بقري', 'جبن شيدر', 'خس', 'طماطم', 'صوص جبن'],
                'allergens' => ['جلوتين', 'ألبان'],
                'sort_order' => 2
            ],
            
            // البرجر المميز
            [
                'category_id' => 2,
                'name' => 'تكساس برجر',
                'name_en' => 'Texas Burger',
                'description' => 'برجر مميز بالصوص الحار، بصل مكرمل، جبن مونتري جاك، وخضار طازجة',
                'price' => 135.00,
                'original_price' => 160.00,
                'image' => 'texas-burger.jpg',
                'is_featured' => true,
                'is_popular' => true,
                'preparation_time' => '18-25 دقيقة',
                'calories' => 800,
                'ingredients' => ['لحم بقري', 'جبن مونتري جاك', 'بصل مكرمل', 'صوص حار', 'خضار'],
                'allergens' => ['جلوتين', 'ألبان', 'بهارات حارة'],
                'customizations' => [
                    'مستوى الحرارة' => ['خفيف', 'متوسط', 'حار جداً'],
                    'الإضافات' => ['أفوكادو +15 جنيه', 'فلفل هالبينو +10 جنيه']
                ],
                'sort_order' => 1
            ],
            [
                'category_id' => 2,
                'name' => 'دليمار برجر',
                'name_en' => 'Delimar Burger',
                'description' => 'برجر فاخر بقطعتين لحم، جبن سويسري، فطر مشوي، وصوص الدليمار الخاص',
                'price' => 155.00,
                'original_price' => null,
                'image' => 'delimar-burger.jpg',
                'is_featured' => true,
                'is_popular' => false,
                'preparation_time' => '20-25 دقيقة',
                'calories' => 950,
                'ingredients' => ['لحم بقري مضاعف', 'جبن سويسري', 'فطر مشوي', 'صوص دليمار'],
                'allergens' => ['جلوتين', 'ألبان', 'فطر'],
                'sort_order' => 2
            ],

            // برجر الدجاج
            [
                'category_id' => 3,
                'name' => 'كرسبي تشيكن',
                'name_en' => 'Crispy Chicken',
                'description' => 'قطعة دجاج مقرمشة مع خس، طماطم، وصوص المايونيز بالثوم',
                'price' => 85.00,
                'original_price' => 100.00,
                'image' => 'crispy-chicken.jpg',
                'is_featured' => false,
                'is_popular' => true,
                'preparation_time' => '12-18 دقيقة',
                'calories' => 580,
                'ingredients' => ['دجاج مقرمش', 'خس', 'طماطم', 'مايونيز بالثوم'],
                'allergens' => ['جلوتين', 'بيض'],
                'sort_order' => 1
            ],

            // الوجبات العائلية
            [
                'category_id' => 4,
                'name' => 'وجبة العائلة الكبيرة',
                'name_en' => 'Family Feast',
                'description' => '4 برجر + 4 بطاطس + 4 مشروبات + صوص إضافي',
                'price' => 320.00,
                'original_price' => 400.00,
                'image' => 'family-feast.jpg',
                'is_featured' => true,
                'is_popular' => false,
                'preparation_time' => '25-30 دقيقة',
                'calories' => 2800,
                'ingredients' => ['برجر متنوع', 'بطاطس', 'مشروبات', 'صوص'],
                'sort_order' => 1
            ],

            // المشروبات
            [
                'category_id' => 5,
                'name' => 'كوكاكولا',
                'name_en' => 'Coca Cola',
                'description' => 'مشروب غازي منعش - زجاجة 330 مل',
                'price' => 12.00,
                'original_price' => null,
                'image' => 'coca-cola.jpg',
                'preparation_time' => 'فوري',
                'calories' => 140,
                'sort_order' => 1
            ],
            [
                'category_id' => 5,
                'name' => 'عصير برتقال طبيعي',
                'name_en' => 'Fresh Orange Juice',
                'description' => 'عصير برتقال طازج 100% طبيعي',
                'price' => 18.00,
                'image' => 'orange-juice.jpg',
                'preparation_time' => '3-5 دقائق',
                'calories' => 110,
                'sort_order' => 2
            ],

            // الحلويات
            [
                'category_id' => 6,
                'name' => 'آيس كريم شوكولاتة',
                'name_en' => 'Chocolate Ice Cream',
                'description' => 'آيس كريم بالشوكولاتة البلجيكية الفاخرة',
                'price' => 25.00,
                'image' => 'chocolate-ice-cream.jpg',
                'preparation_time' => 'فوري',
                'calories' => 280,
                'ingredients' => ['شوكولاتة بلجيكية', 'كريمة طازجة'],
                'allergens' => ['ألبان'],
                'sort_order' => 1
            ]
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}

class CouponsTableSeeder extends Seeder
{
    public function run()
    {
        $coupons = [
            [
                'code' => 'WELCOME15',
                'type' => 'percentage',
                'value' => 15.00,
                'minimum_amount' => 100.00,
                'max_discount_amount' => 50.00,
                'usage_limit' => null, // Unlimited
                'description' => 'خصم ترحيبي للعملاء الجدد',
                'starts_at' => Carbon::now(),
                'expires_at' => Carbon::now()->addMonths(3)
            ],
            [
                'code' => 'FIRE20',
                'type' => 'percentage',
                'value' => 20.00,
                'minimum_amount' => 200.00,
                'max_discount_amount' => 80.00,
                'usage_limit' => 100,
                'description' => 'خصم خاص لمدة محدودة',
                'starts_at' => Carbon::now(),
                'expires_at' => Carbon::now()->addDays(30)
            ],
            [
                'code' => 'SAVE25',
                'type' => 'fixed',
                'value' => 25.00,
                'minimum_amount' => 150.00,
                'usage_limit' => 50,
                'description' => 'خصم ثابت 25 جنيه',
                'starts_at' => Carbon::now(),
                'expires_at' => Carbon::now()->addDays(15)
            ],
            [
                'code' => 'WEEKEND30',
                'type' => 'percentage',
                'value' => 30.00,
                'minimum_amount' => 300.00,
                'max_discount_amount' => 100.00,
                'usage_limit' => 200,
                'description' => 'عرض نهاية الأسبوع',
                'starts_at' => Carbon::now()->next(Carbon::FRIDAY),
                'expires_at' => Carbon::now()->next(Carbon::SUNDAY)->endOfDay()
            ],
            [
                'code' => 'FAMILY50',
                'type' => 'fixed',
                'value' => 50.00,
                'minimum_amount' => 400.00,
                'usage_limit' => 30,
                'description' => 'خصم الوجبات العائلية',
                'starts_at' => Carbon::now(),
                'expires_at' => Carbon::now()->addDays(45)
            ]
        ];

        foreach ($coupons as $coupon) {
            Coupon::create($coupon);
        }
    }
}
