@extends('layouts.app')

@section('title', 'إنشاء حساب جديد - أون فاير 🔥')
@section('description', 'أنشئ حساب في أون فاير واحصل على 50 نقطة ولاء مجانية + خصومات حصرية')

@section('content')
<div class="min-h-screen bg-gradient-fire flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div class="text-center">
            <!-- الشعار -->
            <div class="flex justify-center">
                <div class="flex items-center gap-3">
                    <span class="text-5xl animate-fire">🔥</span>
                    <div class="text-white">
                        <h1 class="text-3xl font-bold">أون فاير</h1>
                        <p class="text-orange-200 text-sm">أشهى برجر في دمنهور</p>
                    </div>
                </div>
            </div>
            
            <!-- العنوان -->
            <h2 class="mt-6 text-3xl font-bold text-white">
                انضم إلى عائلة أون فاير! 🎉
            </h2>
            <p class="mt-2 text-lg text-orange-200">
                احصل على 50 نقطة ولاء مجانية عند التسجيل
            </p>
        </div>

        <!-- نموذج التسجيل -->
        <form method="POST" action="{{ route('auth.register.submit') }}" class="mt-8 space-y-6" x-data="registerForm()">
            @csrf
            
            <div class="space-y-4">
                <!-- الاسم -->
                <div>
                    <label for="name" class="block text-sm font-medium text-white mb-2">
                        الاسم الكامل *
                    </label>
                    <div class="relative">
                        <input id="name" 
                               name="name" 
                               type="text" 
                               required 
                               value="{{ old('name') }}"
                               placeholder="أدخل اسمك الكامل"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                        </div>
                    </div>
                    @error('name')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- رقم الهاتف -->
                <div>
                    <label for="phone" class="block text-sm font-medium text-white mb-2">
                        رقم الهاتف *
                    </label>
                    <div class="relative">
                        <input id="phone" 
                               name="phone" 
                               type="tel" 
                               required 
                               value="{{ old('phone') }}"
                               placeholder="01xxxxxxxxx"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg"
                               x-model="phone"
                               @input="formatPhone">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                        </div>
                    </div>
                    @error('phone')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- البريد الإلكتروني -->
                <div>
                    <label for="email" class="block text-sm font-medium text-white mb-2">
                        البريد الإلكتروني (اختياري)
                    </label>
                    <div class="relative">
                        <input id="email" 
                               name="email" 
                               type="email" 
                               value="{{ old('email') }}"
                               placeholder="example@gmail.com"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 3.26a2 2 0 001.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                    </div>
                    @error('email')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- كلمة المرور -->
                <div>
                    <label for="password" class="block text-sm font-medium text-white mb-2">
                        كلمة المرور *
                    </label>
                    <div class="relative">
                        <input id="password" 
                               name="password" 
                               :type="showPassword ? 'text' : 'password'"
                               required 
                               placeholder="اختر كلمة مرور قوية"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg"
                               x-model="password"
                               @input="checkPasswordStrength">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <button type="button" @click="showPassword = !showPassword" class="text-gray-400 hover:text-gray-600">
                                <svg x-show="!showPassword" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                <svg x-show="showPassword" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L8.464 8.464m1.414 1.414L14.82 14.82m-4.942-4.942L9.878 9.878"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    
                    <!-- مؤشر قوة كلمة المرور -->
                    <div x-show="password.length > 0" class="mt-2">
                        <div class="flex items-center gap-2 mb-1">
                            <div class="text-xs text-white">قوة كلمة المرور:</div>
                            <div :class="passwordStrengthClass" class="text-xs font-semibold" x-text="passwordStrengthText"></div>
                        </div>
                        <div class="w-full bg-white/20 rounded-full h-2">
                            <div :class="passwordStrengthBgClass" 
                                 class="h-2 rounded-full transition-all duration-300" 
                                 :style="`width: ${passwordStrength}%`"></div>
                        </div>
                    </div>
                    
                    @error('password')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>

                <!-- تأكيد كلمة المرور -->
                <div>
                    <label for="password_confirmation" class="block text-sm font-medium text-white mb-2">
                        تأكيد كلمة المرور *
                    </label>
                    <div class="relative">
                        <input id="password_confirmation" 
                               name="password_confirmation" 
                               :type="showPasswordConfirm ? 'text' : 'password'"
                               required 
                               placeholder="أعد كتابة كلمة المرور"
                               class="appearance-none relative block w-full px-4 py-3 pr-12 border border-transparent rounded-xl placeholder-gray-400 text-gray-900 bg-white/95 backdrop-blur focus:outline-none focus:ring-2 focus:ring-yellow-300 focus:border-transparent focus:z-10 text-lg"
                               x-model="passwordConfirmation">
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <button type="button" @click="showPasswordConfirm = !showPasswordConfirm" class="text-gray-400 hover:text-gray-600">
                                <svg x-show="!showPasswordConfirm" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                <svg x-show="showPasswordConfirm" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L8.464 8.464m1.414 1.414L14.82 14.82m-4.942-4.942L9.878 9.878"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                    
                    <!-- مطابقة كلمة المرور -->
                    <div x-show="passwordConfirmation.length > 0" class="mt-2">
                        <div class="flex items-center gap-2 text-sm">
                            <div x-show="password === passwordConfirmation" class="text-green-300 flex items-center gap-1">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                كلمتا المرور متطابقتان
                            </div>
                            <div x-show="password !== passwordConfirmation" class="text-red-300 flex items-center gap-1">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                                كلمتا المرور غير متطابقتين
                            </div>
                        </div>
                    </div>
                    
                    @error('password_confirmation')
                        <p class="mt-2 text-sm text-red-200 bg-red-500/20 px-3 py-2 rounded-lg">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- زر التسجيل -->
            <div>
                <button type="submit" 
                        :disabled="loading || !canSubmit"
                        class="group relative w-full flex justify-center py-4 px-4 border border-transparent text-lg font-bold rounded-xl text-fire-600 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-300 transition-all duration-300 transform hover:scale-105 disabled:opacity-50 disabled:cursor-not-allowed disabled:transform-none">
                    <span x-show="!loading" class="flex items-center gap-2">
                        🎉 إنشاء حساب جديد
                    </span>
                    <span x-show="loading" class="flex items-center gap-2">
                        <div class="loading"></div>
                        جاري إنشاء الحساب...
                    </span>
                </button>
            </div>

            <!-- رابط تسجيل الدخول -->
            <div class="text-center">
                <p class="text-white">
                    لديك حساب بالفعل؟ 
                    <a href="{{ route('auth.login') }}" class="font-bold text-yellow-300 hover:text-yellow-200 transition-colors">
                        سجل دخولك هنا
                    </a>
                </p>
            </div>
        </form>

        <!-- مميزات العضوية -->
        <div class="mt-8 bg-white/10 backdrop-blur rounded-2xl p-6">
            <h3 class="text-lg font-bold text-white text-center mb-4">
                🎁 مميزات عضويتك المجانية
            </h3>
            <div class="grid grid-cols-2 gap-4">
                <div class="text-center">
                    <div class="text-3xl mb-2">🏆</div>
                    <div class="text-white font-semibold text-sm">50 نقطة ولاء</div>
                    <div class="text-orange-200 text-xs">عند التسجيل</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl mb-2">💳</div>
                    <div class="text-white font-semibold text-sm">خصم 15%</div>
                    <div class="text-orange-200 text-xs">أول طلب</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl mb-2">🚚</div>
                    <div class="text-white font-semibold text-sm">توصيل أسرع</div>
                    <div class="text-orange-200 text-xs">أولوية عالية</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl mb-2">⭐</div>
                    <div class="text-white font-semibold text-sm">عروض حصرية</div>
                    <div class="text-orange-200 text-xs">للأعضاء فقط</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function registerForm() {
    return {
        phone: '{{ old("phone") }}',
        password: '',
        passwordConfirmation: '',
        showPassword: false,
        showPasswordConfirm: false,
        loading: false,
        passwordStrength: 0,
        passwordStrengthText: '',
        passwordStrengthClass: '',
        passwordStrengthBgClass: '',
        
        get canSubmit() {
            return this.password.length >= 6 && 
                   this.password === this.passwordConfirmation &&
                   this.phone.length === 11;
        },
        
        init() {
            // استمع لإرسال النموذج
            this.$el.addEventListener('submit', (e) => {
                this.loading = true;
            });
        },
        
        formatPhone() {
            this.phone = this.phone.replace(/\D/g, '');
            if (this.phone.length > 11) {
                this.phone = this.phone.slice(0, 11);
            }
        },
        
        checkPasswordStrength() {
            const password = this.password;
            let strength = 0;
            
            if (password.length >= 6) strength += 25;
            if (password.length >= 8) strength += 25;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength += 25;
            if (/\d/.test(password)) strength += 25;
            
            this.passwordStrength = strength;
            
            if (strength < 25) {
                this.passwordStrengthText = 'ضعيف';
                this.passwordStrengthClass = 'text-red-300';
                this.passwordStrengthBgClass = 'bg-red-400';
            } else if (strength < 50) {
                this.passwordStrengthText = 'متوسط';
                this.passwordStrengthClass = 'text-yellow-300';
                this.passwordStrengthBgClass = 'bg-yellow-400';
            } else if (strength < 75) {
                this.passwordStrengthText = 'جيد';
                this.passwordStrengthClass = 'text-blue-300';
                this.passwordStrengthBgClass = 'bg-blue-400';
            } else {
                this.passwordStrengthText = 'قوي';
                this.passwordStrengthClass = 'text-green-300';
                this.passwordStrengthBgClass = 'bg-green-400';
            }
        }
    }
}
</script>
@endpush

<style>
@keyframes fire {
    0% { 
        transform: scale(1) rotate(0deg);
        filter: hue-rotate(0deg);
    }
    100% { 
        transform: scale(1.05) rotate(2deg);
        filter: hue-rotate(30deg);
    }
}

.animate-fire {
    animation: fire 2s ease-in-out infinite alternate;
}
</style>
