@extends('layouts.app')

@section('title', 'سلة التسوق - أون فاير 🔥')
@section('description', 'راجع سلة التسوق واطلب أشهى برجر في دمنهور مع توصيل سريع')

@section('content')
<div class="min-h-screen bg-gray-50 py-8" x-data="cartPage()" x-init="init()">
    <div class="container mx-auto px-4">
        
        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-4xl font-bold text-gray-900 mb-2">
                🛒 سلة التسوق
            </h1>
            <p class="text-gray-600">راجع طلبك قبل الإتمام</p>
        </div>

        <!-- Cart Content -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <!-- Cart Items -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-lg p-6">
                    
                    @if($cartItems->count() > 0)
                        <!-- Items List -->
                        <div class="space-y-6" id="cart-items">
                            @foreach($cartItems as $item)
                                <div class="flex items-start gap-4 p-4 border border-gray-100 rounded-xl hover:shadow-md transition-shadow" 
                                     data-item-id="{{ auth()->check() ? $item->id : $loop->index }}">
                                    
                                    <!-- Product Image -->
                                    <div class="flex-shrink-0">
                                        <img src="{{ auth()->check() ? $item->product->main_image : $item['image'] }}" 
                                             alt="{{ auth()->check() ? $item->product->name : $item['name'] }}"
                                             class="w-20 h-20 object-cover rounded-lg">
                                    </div>

                                    <!-- Product Details -->
                                    <div class="flex-grow">
                                        <h3 class="font-bold text-lg text-gray-900 mb-1">
                                            {{ auth()->check() ? $item->product->name : $item['name'] }}
                                        </h3>
                                        
                                        <!-- Price and Quantity -->
                                        <div class="flex items-center justify-between">
                                            <div class="flex items-center gap-3">
                                                <!-- Quantity Controls -->
                                                <div class="flex items-center border border-gray-200 rounded-lg">
                                                    <button onclick="updateQuantity('{{ auth()->check() ? $item->id : $loop->index }}', 'decrease')"
                                                            class="p-2 hover:bg-gray-100 transition-colors">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path>
                                                        </svg>
                                                    </button>
                                                    <span class="px-4 py-2 font-semibold min-w-[3rem] text-center">
                                                        {{ auth()->check() ? $item->quantity : $item['quantity'] }}
                                                    </span>
                                                    <button onclick="updateQuantity('{{ auth()->check() ? $item->id : $loop->index }}', 'increase')"
                                                            class="p-2 hover:bg-gray-100 transition-colors">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                                        </svg>
                                                    </button>
                                                </div>
                                                
                                                <!-- Price -->
                                                <div class="text-fire-500 font-bold text-lg">
                                                    {{ number_format((auth()->check() ? $item->price : $item['price']) * (auth()->check() ? $item->quantity : $item['quantity']), 0) }} جنيه
                                                </div>
                                            </div>

                                            <!-- Remove Button -->
                                            <button onclick="removeItem('{{ auth()->check() ? $item->id : $loop->index }}')"
                                                    class="text-red-500 hover:text-red-700 p-2 rounded-lg hover:bg-red-50 transition-colors">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Clear Cart Button -->
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <button onclick="clearCart()"
                                    class="text-red-500 hover:text-red-700 text-sm font-medium flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                مسح السلة بالكامل
                            </button>
                        </div>

                    @else
                        <!-- Empty Cart -->
                        <div class="text-center py-16">
                            <div class="text-6xl mb-4">🛒</div>
                            <h3 class="text-2xl font-bold text-gray-900 mb-2">سلة التسوق فارغة</h3>
                            <p class="text-gray-600 mb-6">لم تقم بإضافة أي منتجات بعد</p>
                            <a href="{{ route('products.index') }}" 
                               class="btn-fire text-white px-8 py-3 rounded-xl font-semibold inline-flex items-center gap-2">
                                🍔 تصفح القائمة
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                </svg>
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Order Summary -->
            @if($cartItems->count() > 0)
            <div class="lg:col-span-1">
                <div class="bg-white rounded-2xl shadow-lg p-6 sticky top-8">
                    <h3 class="text-xl font-bold text-gray-900 mb-6">ملخص الطلب</h3>

                    <!-- Subtotal -->
                    <div class="flex justify-between items-center py-3">
                        <span class="text-gray-600">المجموع الفرعي</span>
                        <span class="font-semibold" id="subtotal">{{ number_format($subtotal, 0) }} جنيه</span>
                    </div>

                    <!-- Delivery Fee -->
                    <div class="flex justify-between items-center py-3">
                        <span class="text-gray-600">رسوم التوصيل</span>
                        <span class="font-semibold" id="delivery-fee">
                            @if($deliveryFee > 0)
                                {{ number_format($deliveryFee, 0) }} جنيه
                            @else
                                <span class="text-green-600">مجاني 🎉</span>
                            @endif
                        </span>
                    </div>

                    <!-- Discount -->
                    @if($discount > 0)
                    <div class="flex justify-between items-center py-3 text-green-600">
                        <span>الخصم</span>
                        <span class="font-semibold">-{{ number_format($discount, 0) }} جنيه</span>
                    </div>
                    @endif

                    <!-- Total -->
                    <div class="flex justify-between items-center py-4 border-t border-gray-200">
                        <span class="text-xl font-bold text-gray-900">الإجمالي</span>
                        <span class="text-xl font-bold text-fire-500" id="total">{{ number_format($total, 0) }} جنيه</span>
                    </div>

                    <!-- Checkout Button -->
                    <div class="space-y-3">
                        @auth
                            <a href="{{ route('orders.checkout') }}" 
                               class="w-full btn-fire text-white py-4 rounded-xl font-bold text-lg text-center block">
                                🔥 إتمام الطلب
                            </a>
                        @else
                            <a href="{{ route('auth.login') }}" 
                               class="w-full btn-fire text-white py-4 rounded-xl font-bold text-lg text-center block">
                                تسجيل دخول وإتمام الطلب
                            </a>
                        @endauth
                    </div>

                    <!-- Continue Shopping -->
                    <div class="mt-4">
                        <a href="{{ route('products.index') }}" 
                           class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 py-3 rounded-xl font-semibold text-center block transition-colors">
                            🛒 متابعة التسوق
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function cartPage() {
    return {
        init() {
            console.log('Cart page initialized');
        }
    }
}

async function updateQuantity(itemId, action) {
    // Implementation here
}

async function removeItem(itemId) {
    // Implementation here  
}

async function clearCart() {
    // Implementation here
}
</script>
@endpush
