<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- SEO Meta Tags -->
    <title>@yield('title', 'أون فاير 🔥 | أشهى برجر في دمنهور | توصيل سريع')</title>
    <meta name="description" content="@yield('description', 'أون فاير - أشهى برجر في دمنهور. طلب أونلاين، توصيل سريع في 30 دقيقة، أسعار مميزة. كلاسيك برجر، تكساس برجر، دليمار برجر.')">
    <meta name="keywords" content="@yield('keywords', 'برجر, دمنهور, توصيل, أون فاير, طعام, مطعم, burger, delivery, food')">
    <meta name="author" content="Burger On Fire">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="@yield('og_title', 'أون فاير 🔥 | أشهى برجر في دمنهور')">
    <meta property="og:description" content="@yield('og_description', 'أشهى برجر في دمنهور - توصيل سريع في 30 دقيقة')">
    <meta property="og:image" content="@yield('og_image', asset('images/og-image.jpg'))">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ url()->current() }}">
    <meta property="twitter:title" content="@yield('twitter_title', 'أون فاير 🔥 | أشهى برجر في دمنهور')">
    <meta property="twitter:description" content="@yield('twitter_description', 'أشهى برجر في دمنهور - توصيل سريع في 30 دقيقة')">
    <meta property="twitter:image" content="@yield('twitter_image', asset('images/og-image.jpg'))">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('images/apple-touch-icon.png') }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('images/favicon-32x32.png') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('images/favicon-16x16.png') }}">
    <link rel="manifest" href="{{ asset('manifest.json') }}">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700;800;900&family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Theme Color -->
    <meta name="theme-color" content="#f97316">
    <meta name="msapplication-TileColor" content="#f97316">
    
    <!-- TailwindCSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'fire': {
                            50: '#fff7ed',
                            100: '#ffedd5', 
                            200: '#fed7aa',
                            300: '#fdba74',
                            400: '#fb923c',
                            500: '#f97316',
                            600: '#ea580c',
                            700: '#c2410c',
                            800: '#9a3412',
                            900: '#7c2d12'
                        }
                    },
                    fontFamily: {
                        'arabic': ['Cairo', 'Tajawal', 'sans-serif']
                    },
                    animation: {
                        'fire': 'fire 2s ease-in-out infinite alternate',
                        'float': 'float 6s ease-in-out infinite'
                    }
                }
            }
        }
    </script>
    
    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Cairo', 'Tajawal', sans-serif;
            line-height: 1.6;
        }
        
        @keyframes fire {
            0% { 
                transform: scale(1) rotate(0deg);
                filter: hue-rotate(0deg);
            }
            100% { 
                transform: scale(1.05) rotate(2deg);
                filter: hue-rotate(30deg);
            }
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        .btn-fire {
            background: linear-gradient(135deg, #f97316 0%, #ef4444 100%);
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(249, 115, 22, 0.4);
        }
        
        .btn-fire:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(249, 115, 22, 0.6);
        }
        
        .gradient-fire {
            background: linear-gradient(135deg, #f97316 0%, #ef4444 100%);
        }
        
        .text-fire-gradient {
            background: linear-gradient(135deg, #f97316, #ef4444);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #f97316;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .toast {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
            padding: 16px;
            border-radius: 8px;
            color: white;
            font-weight: 500;
            transform: translateX(400px);
            transition: transform 0.3s ease;
        }
        
        .toast.show {
            transform: translateX(0);
        }
        
        .toast.success {
            background: linear-gradient(135deg, #10b981, #059669);
        }
        
        .toast.error {
            background: linear-gradient(135deg, #ef4444, #dc2626);
        }
        
        .toast.info {
            background: linear-gradient(135deg, #3b82f6, #2563eb);
        }
    </style>
    
    @stack('styles')
</head>
<body class="bg-gray-50 font-arabic">
    
    <!-- Navigation -->
    @include('partials.navbar')
    
    <!-- Main Content -->
    <main class="min-h-screen">
        @yield('content')
    </main>
    
    <!-- Footer -->
    @include('partials.footer')
    
    <!-- Loading Overlay -->
    <div id="loading-overlay" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg p-6 flex flex-col items-center">
            <div class="loading mb-4"></div>
            <p class="text-gray-700">جاري التحميل...</p>
        </div>
    </div>
    
    <!-- Toast Container -->
    <div id="toast-container" class="fixed top-4 right-4 z-50 space-y-2"></div>
    
    <!-- Scripts -->
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    
    <script>
        // Toast Notifications
        function showToast(message, type = 'success') {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.innerHTML = `
                <div class="flex items-center justify-between">
                    <span>${message}</span>
                    <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-white hover:text-gray-200">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            `;
            
            container.appendChild(toast);
            
            // Show toast
            setTimeout(() => toast.classList.add('show'), 100);
            
            // Auto hide after 4 seconds
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => toast.remove(), 300);
            }, 4000);
        }
        
        // Loading functions
        function showLoading() {
            document.getElementById('loading-overlay').classList.remove('hidden');
        }
        
        function hideLoading() {
            document.getElementById('loading-overlay').classList.add('hidden');
        }
        
        // AJAX Setup
        function setupAjax() {
            // Add CSRF token to all AJAX requests
            const token = document.querySelector('meta[name="csrf-token"]');
            if (token) {
                window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.getAttribute('content');
                
                // For jQuery if used
                if (window.$) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': token.getAttribute('content')
                        }
                    });
                }
            }
        }
        
        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            setupAjax();
            
            // Show success/error messages from session
            @if(session('success'))
                showToast("{{ session('success') }}", 'success');
            @endif
            
            @if(session('error'))
                showToast("{{ session('error') }}", 'error');
            @endif
            
            @if(session('info'))
                showToast("{{ session('info') }}", 'info');
            @endif
        });
        
        // Utility functions
        function formatPrice(price) {
            return new Intl.NumberFormat('ar-EG').format(price) + ' جنيه';
        }
        
        function formatDate(date) {
            return new Intl.DateTimeFormat('ar-EG').format(new Date(date));
        }
        
        function formatTime(date) {
            return new Intl.DateTimeFormat('ar-EG', {
                hour: '2-digit',
                minute: '2-digit'
            }).format(new Date(date));
        }
    </script>
    
    @stack('scripts')
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('SW registered: ', registration);
                    })
                    .catch(function(registrationError) {
                        console.log('SW registration failed: ', registrationError);
                    });
            });
        }
    </script>
    
    <!-- Google Analytics -->
    @if(env('GOOGLE_ANALYTICS_ID'))
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ env('GOOGLE_ANALYTICS_ID') }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '{{ env('GOOGLE_ANALYTICS_ID') }}');
    </script>
    @endif
    
</body>
</html>
