<!-- Footer -->
<footer class="bg-gray-900 text-white">
    <!-- القسم الرئيسي -->
    <div class="container mx-auto px-4 py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            
            <!-- معلومات المطعم -->
            <div class="space-y-4">
                <div class="flex items-center gap-2">
                    <span class="text-3xl animate-fire">🔥</span>
                    <div>
                        <h3 class="text-xl font-bold text-fire-gradient">أون فاير</h3>
                        <p class="text-sm text-gray-400">أشهى برجر في دمنهور</p>
                    </div>
                </div>
                <p class="text-gray-300 text-sm leading-relaxed">
                    نقدم لك أشهى أنواع البرجر المحضر بأجود المكونات وأفضل النكهات. 
                    نضمن لك تجربة طعام لا تُنسى مع توصيل سريع وخدمة مميزة.
                </p>
                
                <!-- تقييم المطعم -->
                <div class="flex items-center gap-2">
                    <div class="flex text-yellow-400">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    </div>
                    <span class="text-sm text-gray-300">4.8 من 5 (1,254 تقييم)</span>
                </div>
            </div>

            <!-- روابط سريعة -->
            <div class="space-y-4">
                <h3 class="text-lg font-bold">روابط سريعة</h3>
                <ul class="space-y-2">
                    <li><a href="{{ route('home') }}" class="footer-link">الرئيسية</a></li>
                    <li><a href="{{ route('products.index') }}" class="footer-link">القائمة</a></li>
                    <li><a href="{{ route('products.featured') }}" class="footer-link">المنتجات المميزة</a></li>
                    <li><a href="{{ route('products.offers') }}" class="footer-link">العروض</a></li>
                    <li><a href="{{ route('about') }}" class="footer-link">من نحن</a></li>
                    <li><a href="{{ route('contact') }}" class="footer-link">تواصل معنا</a></li>
                </ul>
            </div>

            <!-- خدمة العملاء -->
            <div class="space-y-4">
                <h3 class="text-lg font-bold">خدمة العملاء</h3>
                <ul class="space-y-2">
                    @auth
                        <li><a href="{{ route('profile.index') }}" class="footer-link">حسابي</a></li>
                        <li><a href="{{ route('orders.index') }}" class="footer-link">طلباتي</a></li>
                        <li><a href="{{ route('profile.favorites') }}" class="footer-link">المفضلة</a></li>
                        <li><a href="{{ route('profile.loyalty') }}" class="footer-link">نقاط الولاء</a></li>
                    @else
                        <li><a href="{{ route('auth.login') }}" class="footer-link">تسجيل دخول</a></li>
                        <li><a href="{{ route('auth.register') }}" class="footer-link">إنشاء حساب</a></li>
                    @endauth
                    <li><a href="{{ route('guest.track') }}" class="footer-link">تتبع طلبك</a></li>
                    <li><a href="#" class="footer-link">سياسة الخصوصية</a></li>
                    <li><a href="#" class="footer-link">الشروط والأحكام</a></li>
                </ul>
            </div>

            <!-- معلومات التواصل -->
            <div class="space-y-4">
                <h3 class="text-lg font-bold">تواصل معنا</h3>
                
                <!-- الهاتف -->
                <div class="flex items-center gap-3">
                    <div class="flex-shrink-0 w-10 h-10 bg-fire-500 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium">اتصل بنا</p>
                        <p class="text-sm text-gray-400" dir="ltr">{{ env('RESTAURANT_PHONE', '01234567890') }}</p>
                    </div>
                </div>

                <!-- العنوان -->
                <div class="flex items-center gap-3">
                    <div class="flex-shrink-0 w-10 h-10 bg-fire-500 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium">موقعنا</p>
                        <p class="text-sm text-gray-400">{{ env('RESTAURANT_ADDRESS', 'دمنهور، البحيرة، مصر') }}</p>
                    </div>
                </div>

                <!-- ساعات العمل -->
                <div class="flex items-center gap-3">
                    <div class="flex-shrink-0 w-10 h-10 bg-fire-500 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium">ساعات العمل</p>
                        <p class="text-sm text-gray-400">24 ساعة طوال الأسبوع</p>
                    </div>
                </div>

                <!-- وسائل التواصل الاجتماعي -->
                <div class="pt-2">
                    <h4 class="font-medium mb-3">تابعنا على</h4>
                    <div class="flex gap-3">
                        <a href="{{ env('FACEBOOK_URL', '#') }}" 
                           target="_blank"
                           class="w-10 h-10 bg-blue-600 hover:bg-blue-700 rounded-lg flex items-center justify-center transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="{{ env('INSTAGRAM_URL', '#') }}" 
                           target="_blank"
                           class="w-10 h-10 bg-pink-600 hover:bg-pink-700 rounded-lg flex items-center justify-center transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 6.624 5.367 11.99 11.988 11.99s11.988-5.366 11.988-11.99C24.005 5.367 18.641.001 12.017.001zm0 21.424c-5.209 0-9.436-4.227-9.436-9.437S6.808 2.551 12.017 2.551s9.436 4.226 9.436 9.436-4.227 9.437-9.436 9.437z"/>
                                <path d="M16.624 6.712a1.26 1.26 0 11-2.52 0 1.26 1.26 0 012.52 0zM12.017 7.616c-2.414 0-4.371 1.957-4.371 4.371s1.957 4.371 4.371 4.371 4.371-1.957 4.371-4.371-1.957-4.371-4.371-4.371zm0 7.205c-1.562 0-2.834-1.272-2.834-2.834s1.272-2.834 2.834-2.834 2.834 1.272 2.834 2.834-1.272 2.834-2.834 2.834z"/>
                            </svg>
                        </a>
                        <a href="{{ env('TWITTER_URL', '#') }}" 
                           target="_blank"
                           class="w-10 h-10 bg-black hover:bg-gray-800 rounded-lg flex items-center justify-center transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
                            </svg>
                        </a>
                        <a href="https://wa.me/{{ str_replace(['0', '+'], ['2', ''], env('RESTAURANT_PHONE', '01234567890')) }}" 
                           target="_blank"
                           class="w-10 h-10 bg-green-600 hover:bg-green-700 rounded-lg flex items-center justify-center transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.890-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- النشرة الإخبارية -->
    <div class="bg-fire-600">
        <div class="container mx-auto px-4 py-8">
            <div class="text-center">
                <h3 class="text-xl font-bold text-white mb-2">اشترك في نشرتنا الإخبارية</h3>
                <p class="text-fire-100 mb-6">احصل على آخر العروض والأخبار مباشرة في بريدك الإلكتروني</p>
                
                <form method="POST" action="{{ route('newsletter.subscribe') }}" 
                      class="max-w-md mx-auto flex gap-2"
                      x-data="newsletter()">
                    @csrf
                    <input type="email" 
                           name="email"
                           placeholder="أدخل بريدك الإلكتروني"
                           required
                           class="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-white">
                    <button type="submit" 
                            class="bg-white text-fire-600 px-6 py-3 rounded-lg font-medium hover:bg-gray-100 transition-colors flex items-center gap-2"
                            :disabled="loading">
                        <span x-show="!loading">اشترك</span>
                        <div x-show="loading" class="loading"></div>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- حقوق النشر -->
    <div class="bg-gray-800 py-4">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                <div class="text-gray-400 text-sm">
                    © {{ date('Y') }} أون فاير. جميع الحقوق محفوظة.
                </div>
                <div class="flex items-center gap-4 text-gray-400 text-sm">
                    <span>صُنع بحب في مصر 🇪🇬</span>
                    <span>|</span>
                    <span>متاح على الهواتف الذكية 📱</span>
                </div>
            </div>
        </div>
    </div>
</footer>

<!-- زر الانتقال للأعلى -->
<button id="scroll-to-top" 
        class="fixed bottom-6 left-6 w-12 h-12 bg-fire-500 hover:bg-fire-600 text-white rounded-full shadow-lg transition-all duration-300 opacity-0 invisible z-40"
        onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
    <svg class="w-6 h-6 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
    </svg>
</button>

<style>
.footer-link {
    @apply text-gray-300 hover:text-white text-sm transition-colors;
}

.animate-fire {
    animation: fire 2s ease-in-out infinite alternate;
}

@keyframes fire {
    0% { 
        transform: scale(1) rotate(0deg);
        filter: hue-rotate(0deg);
    }
    100% { 
        transform: scale(1.05) rotate(2deg);
        filter: hue-rotate(30deg);
    }
}

.text-fire-gradient {
    background: linear-gradient(135deg, #f97316, #ef4444);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}
</style>

<script>
// Scroll to top button
window.addEventListener('scroll', function() {
    const scrollButton = document.getElementById('scroll-to-top');
    if (window.pageYOffset > 300) {
        scrollButton.classList.remove('opacity-0', 'invisible');
        scrollButton.classList.add('opacity-100', 'visible');
    } else {
        scrollButton.classList.add('opacity-0', 'invisible');
        scrollButton.classList.remove('opacity-100', 'visible');
    }
});

// Newsletter subscription
function newsletter() {
    return {
        loading: false,
        
        init() {
            this.$el.addEventListener('submit', (e) => {
                e.preventDefault();
                this.submit();
            });
        },
        
        async submit() {
            this.loading = true;
            
            try {
                const formData = new FormData(this.$el);
                const response = await fetch(this.$el.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    }
                });
                
                if (response.ok) {
                    showToast('تم الاشتراك بنجاح! شكراً لك', 'success');
                    this.$el.reset();
                } else {
                    throw new Error('فشل في الاشتراك');
                }
            } catch (error) {
                showToast('حدث خطأ أثناء الاشتراك. يرجى المحاولة مرة أخرى', 'error');
            } finally {
                this.loading = false;
            }
        }
    }
}
</script>
