<!-- شريط معلومات سريع -->
<div class="bg-gradient-fire text-white py-2 text-sm">
    <div class="container mx-auto px-4 flex justify-between items-center">
        <div class="flex items-center gap-4">
            <div class="flex items-center gap-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <span>توصيل خلال 30 دقيقة</span>
            </div>
            <div class="flex items-center gap-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                </svg>
                <span>اتصل بنا: {{ env('RESTAURANT_PHONE', '01234567890') }}</span>
            </div>
        </div>
        <div class="flex items-center gap-1">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
            </svg>
            <span>{{ env('RESTAURANT_ADDRESS', 'دمنهور، البحيرة') }}</span>
        </div>
    </div>
</div>

<!-- شريط التنقل الرئيسي -->
<nav x-data="navbar()" 
     :class="scrolled ? 'bg-white/95 backdrop-blur-md shadow-lg' : 'bg-white'" 
     class="sticky top-0 z-50 transition-all duration-300">
    
    <div class="container mx-auto px-4">
        <div class="flex justify-between items-center py-4">
            
            <!-- الشعار -->
            <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                <div class="text-3xl animate-fire">🔥</div>
                <div>
                    <h1 class="text-2xl font-bold text-fire-gradient">أون فاير</h1>
                    <p class="text-xs text-gray-600">أشهى برجر في دمنهور</p>
                </div>
            </a>

            <!-- روابط التنقل - Desktop -->
            <div class="hidden md:flex items-center gap-8">
                <a href="{{ route('home') }}" 
                   class="nav-link {{ request()->routeIs('home') ? 'active' : '' }}">
                    🏠 الرئيسية
                </a>
                <a href="{{ route('products.index') }}" 
                   class="nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}">
                    🍔 القائمة
                </a>
                <a href="{{ route('about') }}" 
                   class="nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
                    📖 من نحن
                </a>
                <a href="{{ route('contact') }}" 
                   class="nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
                    📞 تواصل معنا
                </a>
            </div>

            <!-- أدوات المستخدم -->
            <div class="flex items-center gap-4">
                
                <!-- سلة التسوق -->
                <a href="{{ route('cart.index') }}" 
                   class="relative p-2 hover:bg-gray-100 rounded-lg transition-colors group">
                    <svg class="w-6 h-6 text-gray-700 group-hover:text-fire-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m2.6 8L6 5H3m4 8a2 2 0 110 4m0-4v4m6-4v4m6-4a2 2 0 110 4"></path>
                    </svg>
                    <span x-show="cartCount > 0" 
                          x-text="cartCount"
                          class="absolute -top-1 -right-1 bg-fire-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center scale-0"
                          x-transition.scale>
                    </span>
                </a>

                <!-- حساب المستخدم -->
                @auth
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" 
                                class="hidden md:flex items-center gap-2 p-2 hover:bg-gray-100 rounded-lg transition-colors group">
                            <img src="{{ auth()->user()->avatar_url }}" 
                                 alt="{{ auth()->user()->name }}" 
                                 class="w-8 h-8 rounded-full">
                            <span class="text-gray-700 group-hover:text-fire-500">
                                {{ auth()->user()->name }}
                            </span>
                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        
                        <!-- القائمة المنسدلة -->
                        <div x-show="open" 
                             x-transition 
                             @click.away="open = false"
                             class="absolute left-0 mt-2 w-48 bg-white rounded-lg shadow-lg border py-2 z-50">
                            <a href="{{ route('profile.index') }}" class="dropdown-item">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                                الملف الشخصي
                            </a>
                            <a href="{{ route('orders.index') }}" class="dropdown-item">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M8 11v6h8v-6H8z"></path>
                                </svg>
                                طلباتي
                            </a>
                            <a href="{{ route('profile.favorites') }}" class="dropdown-item">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                </svg>
                                المفضلة
                            </a>
                            <div class="border-t my-2"></div>
                            <form method="POST" action="{{ route('auth.logout') }}">
                                @csrf
                                <button type="submit" class="dropdown-item text-red-600 w-full text-right">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                    </svg>
                                    تسجيل الخروج
                                </button>
                            </form>
                        </div>
                    </div>
                @else
                    <a href="{{ route('auth.login') }}" 
                       class="hidden md:flex items-center gap-2 p-2 hover:bg-gray-100 rounded-lg transition-colors group">
                        <svg class="w-6 h-6 text-gray-700 group-hover:text-fire-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                        <span class="text-gray-700 group-hover:text-fire-500">تسجيل دخول</span>
                    </a>
                @endauth

                <!-- زر القائمة - Mobile -->
                <button @click="mobileMenuOpen = !mobileMenuOpen"
                        class="md:hidden p-2 hover:bg-gray-100 rounded-lg transition-colors">
                    <svg x-show="!mobileMenuOpen" class="w-6 h-6 text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                    <svg x-show="mobileMenuOpen" class="w-6 h-6 text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- القائمة المنسدلة - Mobile -->
    <div x-show="mobileMenuOpen" 
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 transform -translate-y-2"
         x-transition:enter-end="opacity-1 transform translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-1 transform translate-y-0"
         x-transition:leave-end="opacity-0 transform -translate-y-2"
         class="md:hidden bg-white border-t border-gray-200">
        
        <div class="container mx-auto px-4 py-4">
            <div class="space-y-4">
                
                <!-- روابط التنقل -->
                <a href="{{ route('home') }}" class="mobile-nav-link {{ request()->routeIs('home') ? 'active' : '' }}">
                    <span class="text-xl">🏠</span>
                    <span class="font-medium">الرئيسية</span>
                </a>
                
                <a href="{{ route('products.index') }}" class="mobile-nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}">
                    <span class="text-xl">🍔</span>
                    <span class="font-medium">القائمة</span>
                </a>
                
                <a href="{{ route('about') }}" class="mobile-nav-link {{ request()->routeIs('about') ? 'active' : '' }}">
                    <span class="text-xl">📖</span>
                    <span class="font-medium">من نحن</span>
                </a>
                
                <a href="{{ route('contact') }}" class="mobile-nav-link {{ request()->routeIs('contact') ? 'active' : '' }}">
                    <span class="text-xl">📞</span>
                    <span class="font-medium">تواصل معنا</span>
                </a>

                @auth
                    <!-- حساب المستخدم - Mobile -->
                    <div class="border-t border-gray-200 pt-4">
                        <a href="{{ route('profile.index') }}" class="mobile-nav-link">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <span class="font-medium">حسابي - {{ auth()->user()->name }}</span>
                        </a>
                    </div>
                @else
                    <div class="border-t border-gray-200 pt-4">
                        <a href="{{ route('auth.login') }}" class="mobile-nav-link">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <span class="font-medium">تسجيل دخول</span>
                        </a>
                    </div>
                @endauth

                <!-- معلومات سريعة -->
                <div class="bg-fire-50 p-4 rounded-lg">
                    <div class="flex items-center justify-between text-sm">
                        <div class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-fire-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                            </svg>
                            <span>تقييم المطعم</span>
                        </div>
                        <span class="font-bold text-fire-500">4.8/5</span>
                    </div>
                    <div class="flex items-center justify-between text-sm mt-2">
                        <div class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-fire-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>وقت التوصيل</span>
                        </div>
                        <span class="font-bold text-fire-500">25-30 دقيقة</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</nav>

<style>
.nav-link {
    @apply flex items-center gap-2 font-medium transition-all duration-300 hover:text-fire-500 px-3 py-2 rounded-lg;
}

.nav-link.active {
    @apply text-fire-500 bg-fire-50;
}

.mobile-nav-link {
    @apply flex items-center gap-3 p-3 rounded-lg transition-colors text-gray-700 hover:bg-gray-50;
}

.mobile-nav-link.active {
    @apply bg-fire-50 text-fire-500;
}

.dropdown-item {
    @apply flex items-center gap-2 px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 transition-colors;
}
</style>

<script>
function navbar() {
    return {
        scrolled: false,
        mobileMenuOpen: false,
        cartCount: 0,
        
        init() {
            // Handle scroll effect
            window.addEventListener('scroll', () => {
                this.scrolled = window.scrollY > 50;
            });
            
            // Load cart count
            this.updateCartCount();
            
            // Close mobile menu on route change
            window.addEventListener('beforeunload', () => {
                this.mobileMenuOpen = false;
            });
        },
        
        updateCartCount() {
            // Fetch cart count from API or localStorage
            fetch('{{ route("cart.count") }}')
                .then(response => response.json())
                .then(data => {
                    this.cartCount = data.count || 0;
                })
                .catch(error => {
                    console.error('Error fetching cart count:', error);
                });
        }
    }
}
</script>
